#==============================================================================#
#==                    Ministerio de Educación del Ecuador                   ==#  
#==                  Subsecretaría de Fundamentos Educativos                 ==#
#==              Dirección Nacional de Investigación Educativa               ==#
#==============================================================================#

#==============================================================================#
#==    Elaborado por: Jhony Zabala                                           ==#
#==    Revisado: Rocio Soria                                                 ==#
#==    Aprobado por: Galo López                                              ==#
#==                                                                          ==#
#==    Fecha elaboración; 02/08/2022                                         ==#
#==============================================================================#

#==============================================================================#
#==    Indicaciones generales                                                ==#
#==                                                                          ==#
#==    1. Para poder instalar las librerías primero debe descargarse los     ==#
#==       paquetes, ejemplo;                                                 ==#
#==                         install.packages("tidyverse")                    ==#
#==    2.   setwd Ingrese la ruta de la carpeta donde vas a trabajar entre   ==#
#==          comillas                                                        ==#
#==                                                                          ==#
#==    3. Para abrir el archivo csv, debe copiar y pegar la ruta donde se    ==#
#==       encuentra guardado el archivo, además debe cambiar "\" por "/"     ==#
#==                                                                          ==#
#==    4. Al exportar las tablas creadas mediante el comando "saveWorkbook"  ==#
#==      copie y pegue la ruta donde desea guardar el archivo                ==#
#==                                                                          ==#
#==============================================================================#



setwd("")#Ingresa la ruta de la carpeta donde vas a trabajar, cambia "\" por "/"
library(readr)
library(tidyverse)
library(openxlsx)
data1 <- read.csv2("PEGA LA RUTA AQUÍ",na.strings="",encoding="UTF-8")# copia y pega la ruta del archivo csv, cambia "\" por "/"

#==================================================#
#========== PORCENTAJE POR PROVINCIAS==============#
#==================================================#

prov <- data1 %>% group_by(p5) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- prov %>% 
  select_if(is.numeric) %>% 
  colSums()

prov <- bind_rows(prov, Total)

tprov <- write.xlsx(prov,".xlsx")
saveWorkbook(tprov,file = "PEGA LA RUTA AQUI/1.provincias.xlsx", overwrite = T)#copia y pega la ruta del archivo, donde quieres se guarde el archivo


#====================================================#
#======================= EDAD =======================#
#====================================================#
  

edad <- data1 %>% filter(p6<=23) %>% 
  summarize(minimo=min(p6,na.rm = T),
            media=mean(p6,na.rm=T),
            mediana=median(p6,na.rm=T),
            maximo=max(p6,na.rm=T))

tedad <- write.xlsx(edad,".xlsx")
saveWorkbook(tedad,file = "PEGA LA RUTA AQUI/2.edad.xlsx", overwrite = T)


#====================================================#
#===================== AUTOIDENTIFICACIÓN ===========#
#====================================================#

etnia <- data1 %>% group_by(p7) %>% 
summarise(Total=n())%>%
mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
arrange(desc(Porcentaje))

Total <- etnia %>% 
  select_if(is.numeric) %>% 
  colSums()

etnia <- bind_rows(etnia, Total)


tetnia <- write.xlsx(etnia,".xlsx")
saveWorkbook(tetnia,file = "PEGA LA RUTA AQUI/3.etnia.xlsx", overwrite = T)

#====================================================#
#==================== GÉNERO ========================#
#====================================================#
  

gen <- data1 %>% group_by(p8) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- gen %>% 
  select_if(is.numeric) %>% 
  colSums()

gen <- bind_rows(gen, Total)

tgen <- write.xlsx(gen,".xlsx")
saveWorkbook(tgen,file = "PEGA LA RUTA AQUI/4.genero.xlsx", overwrite = T)

#====================================================#
#================ DISCAPACIDAD ======================#
#====================================================#
  

disca <- data1 %>% group_by(p9) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- disca %>% 
  select_if(is.numeric) %>% 
  colSums()

disca <- bind_rows(disca, Total)

tdisca <- write.xlsx(disca,".xlsx")
saveWorkbook(tdisca,file = "PEGA LA RUTA AQUI/5.discapacidad.xlsx", overwrite = T)

#====================================================#
#===================== ÁREA =========================#
#====================================================#
  

urbal <- data1 %>% group_by(p10) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- urbal %>% 
  select_if(is.numeric) %>% 
  colSums()

urbal <- bind_rows(urbal, Total)

turbal <- write.xlsx(urbal,".xlsx")
saveWorkbook(turbal,file = "PEGA LA RUTA AQUI/6.area.xlsx", overwrite = T)

#====================================================#
#============= NACIONALIDAD =========================#
#====================================================#
  

nac <- data1 %>% group_by(p11) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- nac %>% 
  select_if(is.numeric) %>% 
  colSums()

nac <- bind_rows(nac, Total)

tnac <- write.xlsx(nac,".xlsx")
saveWorkbook(tnac,file = "PEGA LA RUTA AQUI/7.nacionalidad.xlsx", overwrite = T)

#====================================================#
#============= SOSTENIMIENTO ========================#
#====================================================#
  

sos <- data1 %>% group_by(p12) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- sos %>% 
  select_if(is.numeric) %>% 
  colSums()

sos <- bind_rows(sos, Total)

tsos <- write.xlsx(sos,".xlsx")
saveWorkbook(tsos,file = "PEGA LA RUTA AQUI/8.sostenimiento.xlsx", overwrite = T)

#====================================================#
#================= MODALIDAD ========================#
#====================================================#
  

mod <- data1 %>% group_by(p13) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- mod %>% 
  select_if(is.numeric) %>% 
  colSums()

mod <- bind_rows(mod, Total)


tmod <- write.xlsx(mod,".xlsx")
saveWorkbook(tmod,file = "PEGA LA RUTA AQUI/9.modalidad.xlsx", overwrite = T)

#====================================================#
#=================== GRADO ==========================#
#====================================================#

grado <- data1 %>% group_by(p14) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- grado %>% 
  select_if(is.numeric) %>% 
  colSums()

grado <- bind_rows(grado, Total)


tgrado <- write.xlsx(grado,".xlsx")
saveWorkbook(tgrado,file = "PEGA LA RUTA AQUI/10.grado.xlsx", overwrite = T)

#==========================================================================#
#=========================== CONSULTAS ENCUESTA  ==========================#
#==========================================================================#

#1. ¿Cuál crees tú que es el desafío más grande para el planeta en el futuro?#


reto <- data1 %>% group_by(p15) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- reto %>% 
  select_if(is.numeric) %>% 
  colSums()

reto <- bind_rows(reto, Total)


treto <- write.xlsx(reto,".xlsx")
saveWorkbook(treto,file = "PEGA LA RUTA AQUI/11.reto.xlsx", overwrite = T)

#2. ¿Cuál crees que debe ser la función más importante de tu institución educativa?

fun <- data1 %>% group_by(p16) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- fun %>% 
  select_if(is.numeric) %>% 
  colSums()

fun <- bind_rows(fun, Total)

tfun <- write.xlsx(fun,".xlsx")
saveWorkbook(tfun,file = "PEGA LA RUTA AQUI/12.funcion.xlsx", overwrite = T)

# 3. ¿Cómo quisieras que sea tu institución educativa? 

deseo <- data1 %>% group_by(p17) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- deseo %>% 
  select_if(is.numeric) %>% 
  colSums()

deseo <- bind_rows(deseo, Total)

tdeseo <- write.xlsx(deseo,".xlsx")
saveWorkbook(tdeseo,file = "PEGA LA RUTA AQUI/13.deseo.xlsx", overwrite = T)

# 4 ¿Crees tú que la educación mejorará luego de la pandemia?

mejor <- data1 %>% group_by(p18) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- mejor %>% 
  select_if(is.numeric) %>% 
  colSums()

mejor <- bind_rows(mejor, Total)

tmejor <- write.xlsx(mejor,".xlsx")
saveWorkbook(tmejor,file = "PEGA LA RUTA AQUI/14.mejor.xlsx", overwrite = T)

# 5.¿Consideras que con el retorno a clases presenciales luego del confinamiento por la pandemia estás: ?

aprender <- data1 %>% group_by(p19) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- aprender %>% 
  select_if(is.numeric) %>% 
  colSums()

aprender <- bind_rows(aprender, Total)

taprender <- write.xlsx(aprender,".xlsx")
saveWorkbook(taprender,file = "PEGA LA RUTA AQUI/15.aprender.xlsx", overwrite = T)

# 6. Respecto a la afirmación: "Mi vida tiene un claro sentido y un propósito", indique si está:

sentido <- data1 %>% group_by(p20) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- sentido %>% 
  select_if(is.numeric) %>% 
  colSums()

sentido <- bind_rows(sentido, Total)


tsentido <- write.xlsx(sentido,".xlsx")
saveWorkbook(tsentido,file = "PEGA LA RUTA AQUI/16.sentido.xlsx", overwrite = T)

# 7. ¿Has considerado en algún momento abandonar los estudios?

abandonar <- data1 %>% group_by(p21) %>% 
  summarise(Total=n())%>%
  mutate(Porcentaje = round(Total/sum(Total)*100, 2))%>%
  arrange(desc(Porcentaje))

Total <- abandonar %>% 
  select_if(is.numeric) %>% 
  colSums()

abandonar <- bind_rows(abandonar, Total)

tabandonar <- write.xlsx(abandonar,".xlsx")
saveWorkbook(tabandonar,file = "PEGA LA RUTA AQUI/17.abandonar.xlsx", overwrite = T)
